<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

if (isset($data->user_id)) {
    $user_id = (int)$data->user_id;
    
    try {
        // Fetch events that the user has registered for
        $stmt = $pdo->prepare("SELECT e.* FROM registrations r JOIN events e ON r.event_id = e.id WHERE r.user_id = :user_id ORDER BY e.event_date ASC");
        $stmt->execute(['user_id' => $user_id]);
        $registrations = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode(["success" => true, "registrations" => $registrations]);
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => "Error fetching registrations: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing user_id"]);
}
?>
