<?php
// forgot_password.php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Connect to DB
require_once 'db_config.php'; // your DB connection

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'] ?? '';

$response = [
  'success' => false,
  'message' => ''
];

if (empty($email)) {
  $response['message'] = "Email is required.";
  echo json_encode($response);
  exit;
}

// Check if user exists
$stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email LIMIT 1");
$stmt->execute([':email' => $email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
  // For security, still pretend it was successful
  $response['success'] = true;
  $response['message'] = "If that email exists in our system, a reset link was sent.";
  echo json_encode($response);
  exit;
}

// Generate token
$token = bin2hex(random_bytes(32)); // 64-char hex string
$user_id = $user['id'];

// Insert or update token in password_resets table
// Make sure you have a table: CREATE TABLE password_resets (id INT AUTO_INCREMENT, user_id INT, token VARCHAR(255), expires_at DATETIME, PRIMARY KEY(id))
$stmt = $pdo->prepare("INSERT INTO password_resets (user_id, token, expires_at) 
                       VALUES (:user_id, :token, DATE_ADD(NOW(), INTERVAL 1 HOUR))
                       ON DUPLICATE KEY UPDATE token = :token, expires_at = DATE_ADD(NOW(), INTERVAL 1 HOUR)");
$stmt->execute([
  ':user_id' => $user_id,
  ':token' => $token
]);

// Build reset link
$resetLink = "http://localhost:3000/reset-password?token=" . $token;

// Send email
// For simplicity, we use mail(); in real usage, consider PHPMailer or another library
$subject = "Password Reset Request";
$message = "Click here to reset your password: $resetLink \nThis link expires in 1 hour.";
$headers = "From: no-reply@yourdomain.com\r\nContent-Type: text/plain; charset=UTF-8\r\n";

mail($email, $subject, $message, $headers);

$response['success'] = true;
$response['message'] = "If that email exists in our system, a reset link was sent.";
echo json_encode($response);
