<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

if (isset($data->user_id) && isset($data->event_id)) {
    $user_id = (int)$data->user_id;
    $event_id = (int)$data->event_id;

    try {
        $stmt = $pdo->prepare("DELETE FROM registrations WHERE user_id = :user_id AND event_id = :event_id");
        $stmt->execute(['user_id' => $user_id, 'event_id' => $event_id]);
        if ($stmt->rowCount() > 0) {
            echo json_encode(["success" => true, "message" => "Registration cancelled successfully"]);
        } else {
            echo json_encode(["success" => false, "message" => "Registration not found"]);
        }
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => "Error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
}
?>
